/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.VWPrintableProperty;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWColorListCellRenderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class VWPrintableTextAnnotationProperty
extends VWPrintableProperty {
    protected static final Image TEXT_ANNOTATION_ICON = VWImageLoader.createImageIcon("text_annotation.gif").getImage();
    protected static final Image ASSOCIATION_ICON = VWImageLoader.createImageIcon("association.gif").getImage();
    protected VWTextAnnotationDefinition m_textAnnotationDef = null;

    public VWPrintableTextAnnotationProperty(VWTextAnnotationDefinition textAnnotationDef, Graphics g, VWPrinter printer) {
        super(g, printer);
        this.m_textAnnotationDef = textAnnotationDef;
    }

    protected void renderPage(Graphics2D g2, PageFormat pf, int idx) throws PrinterException {
        Point p = new Point(0, 0);
        ArrayList page = this.getPage(idx - this.m_startingPage);
        for (String line : page) {
            if (VWStringUtils.compare(line, VWResource.s_textAnnotationProperties) == 0) {
                this.printTitleLine(TEXT_ANNOTATION_ICON, line, p);
                continue;
            }
            if (line.equals(VWResource.s_associationProperties)) {
                this.printTitleLine(ASSOCIATION_ICON, line, p);
                continue;
            }
            if (line.startsWith("[[FOOTER]]")) {
                String footer = line.substring("[[FOOTER]]".length());
                this.printFooterLine(footer);
                continue;
            }
            this.printTextLine(line, p);
        }
    }

    protected void repaginate(PageFormat pf) {
        try {
            this.m_ImageableHeight = (int)pf.getImageableHeight();
            this.m_ImageableWidth = (int)pf.getImageableWidth();
            this.newChapter(this.m_textAnnotationDef.getName());
            this.appendTitleLine(VWResource.s_textAnnotationProperties);
            String aLine = VWResource.s_colon.toString(VWResource.s_name) + this.m_textAnnotationDef.getName();
            this.appendTextLine(aLine, 0, false);
            this.printGeneralInfo();
            VWAssociationDefinition[] associationDefs = this.m_textAnnotationDef.getAllAssociations();
            if (associationDefs != null) {
                for (int i = 0; i < associationDefs.length; ++i) {
                    this.printAssociationProperties(associationDefs[i]);
                }
            }
            this.flushLastPage();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void printGeneralInfo() throws Exception {
        this.appendTextLine(VWResource.s_colon.toString(VWResource.s_general), 0, false);
        String tempString = this.m_textAnnotationDef.getMessage();
        if (tempString != null && tempString.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_message), 1, false);
            StringTokenizer st = new StringTokenizer(tempString, "\n");
            while (st.hasMoreTokens()) {
                this.appendTextLine(st.nextToken(), 2, true);
            }
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_message) + VWResource.s_none, 1, false);
        }
        JLabel colorLabel = VWColorListCellRenderer.getLabel(this.m_textAnnotationDef.getBgColor());
        tempString = colorLabel.getText();
        if (tempString != null && tempString.length() > 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_backgroundColor) + tempString, 1, false);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_backgroundColor) + VWResource.s_none, 1, false);
        }
    }

    private void printAssociationProperties(VWAssociationDefinition associationDef) throws Exception {
        this.newPrintSection();
        this.appendTitleLine(VWResource.s_associationProperties);
        String tempString = associationDef.getName();
        if (tempString == null || tempString.length() == 0) {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + VWResource.s_blankName, 1, true);
        } else {
            this.appendTextLine(VWResource.s_colon.toString(VWResource.s_name) + tempString, 1, true);
        }
        switch (associationDef.getTargetType()) {
            case 1: {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_destinationStepStr) + Integer.toString(associationDef.getTargetId()), 1, true);
                break;
            }
            case 2: {
                this.appendTextLine(VWResource.s_colon.toString(VWResource.s_destinationRouteStr) + Integer.toString(associationDef.getTargetId()), 1, true);
            }
        }
    }
}

